(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8256,        282]*)
(*NotebookOutlinePosition[      8893,        304]*)
(*  CellTagsIndexPosition[      8849,        300]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["DE from Solution", "Subtitle"],

Cell["\<\
Find the diffedrential equation which has this three-parameter \
family as its set of solutions.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr = \((y[
            x] \[Equal] \(c\_1\) \[ExponentialE]\^x + \(c\_2\) \
\[ExponentialE]\^\(\(-2\) x\) + \(c\_3\) \[ExponentialE]\^\(3  x\))\)\)], \
"Input"],

Cell[BoxData[
    \(y[x] == \[ExponentialE]\^x\ c\_1 + \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 \
+ \[ExponentialE]\^\(3\ x\)\ c\_3\)], "Output"]
}, Open  ]],

Cell["The required derivatives..", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((eqns = Table[D[expr, {x, k}], {k, 0, 3}])\) // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(y[
                x] == \[ExponentialE]\^x\ c\_1 + \[ExponentialE]\^\(\(-2\)\ x\
\)\ c\_2 + \[ExponentialE]\^\(3\ x\)\ c\_3\)},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "==", \(\[ExponentialE]\^x\ c\_1 - 
                2\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
                3\ \[ExponentialE]\^\(3\ x\)\ c\_3\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "==", \(\[ExponentialE]\^x\ c\_1 + 
                4\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
                9\ \[ExponentialE]\^\(3\ x\)\ c\_3\)}]},
          {
            RowBox[{
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}], 
              "==", \(\[ExponentialE]\^x\ c\_1 - 
                8\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
                27\ \[ExponentialE]\^\(3\ x\)\ c\_3\)}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {
        Equal[ 
          y[ x], 
          Plus[ 
            Times[ 
              Power[ E, x], 
              Subscript[ c, 1]], 
            Times[ 
              Power[ E, 
                Times[ -2, x]], 
              Subscript[ c, 2]], 
            Times[ 
              Power[ E, 
                Times[ 3, x]], 
              Subscript[ c, 3]]]], 
        Equal[ 
          Derivative[ 1][ y][ x], 
          Plus[ 
            Times[ 
              Power[ E, x], 
              Subscript[ c, 1]], 
            Times[ -2, 
              Power[ E, 
                Times[ -2, x]], 
              Subscript[ c, 2]], 
            Times[ 3, 
              Power[ E, 
                Times[ 3, x]], 
              Subscript[ c, 3]]]], 
        Equal[ 
          Derivative[ 2][ y][ x], 
          Plus[ 
            Times[ 
              Power[ E, x], 
              Subscript[ c, 1]], 
            Times[ 4, 
              Power[ E, 
                Times[ -2, x]], 
              Subscript[ c, 2]], 
            Times[ 9, 
              Power[ E, 
                Times[ 3, x]], 
              Subscript[ c, 3]]]], 
        Equal[ 
          Derivative[ 3][ y][ x], 
          Plus[ 
            Times[ 
              Power[ E, x], 
              Subscript[ c, 1]], 
            Times[ -8, 
              Power[ E, 
                Times[ -2, x]], 
              Subscript[ c, 2]], 
            Times[ 27, 
              Power[ E, 
                Times[ 3, x]], 
              Subscript[ c, 3]]]]}]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Get the DE as a Rule. Solve for y'''[x] while eliminating the parameters \
",
  Cell[BoxData[
      \({c\_1, \ c\_2, \ c\_3}\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DervRule = 
      Simplify[Solve[eqns, \(y'''\)[x], {c\_1, \ c\_2, \ c\_3}]] // 
        First\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
        RowBox[{\(\(-6\)\ y[x]\), "+", 
          RowBox[{"5", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Get the DE as an equation. Change the \[Rule] (Rule) into  \[Equal] \
(Equal).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[x_, y_] = \((First[DervRule] /. Rule \[Rule] Equal)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["y", 
          TagBox[\((3)\),
            Derivative],
          MultilineFunction->None], "[", "x", "]"}], "==", 
      RowBox[{\(\(-6\)\ y[x]\), "+", 
        RowBox[{"5", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"2", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell["Capture the solution.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = expr[\([2]\)]\)], "Input"],

Cell[BoxData[
    \(\[ExponentialE]\^x\ c\_1 + \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + \
\[ExponentialE]\^\(3\ x\)\ c\_3\)], "Output"]
}, Open  ]],

Cell["Check the solution.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[x, s]\)], "Input"],

Cell[BoxData[
    \(\[ExponentialE]\^x\ c\_1 - 8\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
        27\ \[ExponentialE]\^\(3\ x\)\ c\_3 == \(-6\)\ \((\[ExponentialE]\^x\ \
c\_1 + \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + \[ExponentialE]\^\(3\ x\)\ \
c\_3)\) + 
        5\ \((\[ExponentialE]\^x\ c\_1 - 
              2\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
              3\ \[ExponentialE]\^\(3\ x\)\ c\_3)\) + 
        2\ \((\[ExponentialE]\^x\ c\_1 + 
              4\ \[ExponentialE]\^\(\(-2\)\ x\)\ c\_2 + 
              9\ \[ExponentialE]\^\(3\ x\)\ c\_3)\)\)], "Output"]
}, Open  ]],

Cell["It works.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[de[x, s]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{520, 624},
WindowMargins->{{40, Automatic}, {Automatic, 25}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 36, 0, 65, "Subtitle"],
Cell[1815, 55, 120, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[1960, 62, 182, 4, 31, "Input"],
Cell[2145, 68, 141, 2, 29, "Output"]
}, Open  ]],
Cell[2301, 73, 42, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[2368, 77, 92, 1, 27, "Input"],
Cell[2463, 80, 2919, 92, 97, "Output"]
}, Open  ]],
Cell[5397, 175, 166, 6, 32, "Text"],

Cell[CellGroupData[{
Cell[5588, 185, 127, 3, 43, "Input"],
Cell[5718, 190, 613, 17, 29, "Output"]
}, Open  ]],
Cell[6346, 210, 102, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[6473, 217, 89, 1, 27, "Input"],
Cell[6565, 220, 546, 15, 29, "Output"]
}, Open  ]],
Cell[7126, 238, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[7188, 242, 54, 1, 27, "Input"],
Cell[7245, 245, 133, 2, 29, "Output"]
}, Open  ]],
Cell[7393, 250, 35, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[7453, 254, 41, 1, 27, "Input"],
Cell[7497, 257, 574, 10, 47, "Output"]
}, Open  ]],
Cell[8086, 270, 25, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[8136, 274, 51, 1, 27, "Input"],
Cell[8190, 277, 38, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

